/*
 * Decompiled with CFR 0.152.
 */
package me.alphamode.star.world.fluids;

import me.alphamode.star.mixin.EntityAccessor;
import me.alphamode.star.mixin.LivingEntityAccessor;
import me.alphamode.star.world.fluids.DirectionalFluid;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4538;
import net.minecraft.class_5712;

public abstract class StarFluid
extends DirectionalFluid {
    public StarFluid(class_2350 flowDirection) {
        super(flowDirection);
    }

    public boolean method_15780(class_3611 fluid) {
        return fluid == this.method_15751() || fluid == this.method_15750();
    }

    protected boolean method_15737(class_1937 world) {
        return false;
    }

    protected void method_15730(class_1936 world, class_2338 pos, class_2680 state) {
        class_2586 blockEntity = state.method_31709() ? world.method_8321(pos) : null;
        class_2248.method_9610((class_2680)state, (class_1936)world, (class_2338)pos, (class_2586)blockEntity);
    }

    protected boolean method_15777(class_3610 fluidState, class_1922 blockView, class_2338 blockPos, class_3611 fluid, class_2350 direction) {
        return false;
    }

    protected int method_15733(class_4538 worldView) {
        return 4;
    }

    protected int method_15739(class_4538 worldView) {
        return 1;
    }

    public int method_15789(class_4538 worldView) {
        return 5;
    }

    protected float method_15784() {
        return 100.0f;
    }

    public int calculateSubmergedVisibility(class_1657 player, int currentVisibilityTicks) {
        int i = player.method_7325() ? 10 : 1;
        return class_3532.method_15340((int)(currentVisibilityTicks + i), (int)0, (int)600);
    }

    public void onSwimmingStart(class_1297 entity) {
        double e;
        double d;
        class_1297 passenger = entity.method_5782() && entity.method_5642() != null ? entity.method_5642() : entity;
        float f = passenger == entity ? 0.2f : 0.9f;
        class_243 velocity = passenger.method_18798();
        float g = Math.min(1.0f, (float)Math.sqrt(velocity.field_1352 * velocity.field_1352 * (double)0.2f + velocity.field_1351 * velocity.field_1351 + velocity.field_1350 * velocity.field_1350 * (double)0.2f) * f);
        if (g < 0.25f) {
            entity.method_5783(this.getSplashSound(entity), g, 1.0f + (entity.field_5974.method_43057() - entity.field_5974.method_43057()) * 0.4f);
        } else {
            entity.method_5783(this.getHighSpeedSplashSound(entity), g, 1.0f + (entity.field_5974.method_43057() - entity.field_5974.method_43057()) * 0.4f);
        }
        float h = class_3532.method_15357((double)entity.method_23318());
        int i = 0;
        while ((float)i < 1.0f + entity.method_17681() * 20.0f) {
            d = (entity.field_5974.method_43058() * 2.0 - 1.0) * (double)entity.method_17681();
            e = (entity.field_5974.method_43058() * 2.0 - 1.0) * (double)entity.method_17681();
            entity.method_37908().method_8406(this.getBubbleParticle(entity), entity.method_23317() + d, (double)(h + 1.0f), entity.method_23321() + e, velocity.field_1352, velocity.field_1351 - entity.field_5974.method_43058() * (double)0.2f, velocity.field_1350);
            ++i;
        }
        i = 0;
        while ((float)i < 1.0f + entity.method_17681() * 20.0f) {
            d = (entity.field_5974.method_43058() * 2.0 - 1.0) * (double)entity.method_17681();
            e = (entity.field_5974.method_43058() * 2.0 - 1.0) * (double)entity.method_17681();
            entity.method_37908().method_8406(this.getSplashParticle(entity), entity.method_23317() + d, (double)(h + 1.0f), entity.method_23321() + e, velocity.field_1352, velocity.field_1351, velocity.field_1350);
            ++i;
        }
        entity.method_32876(class_5712.field_28160);
    }

    public void knockInFlowDirection(class_1297 entity) {
        entity.method_18799(entity.method_18798().method_1031(0.0, (double)-0.04f, 0.0));
    }

    public void travelInFluid(class_1309 entity, class_243 movementInput, double gravity, boolean falling) {
        double y = entity.method_23318();
        float movementSpeed = entity.method_5624() ? 0.9f : ((LivingEntityAccessor)entity).callGetBaseMovementSpeedMultiplier();
        float yVelocity = 0.02f;
        float depthStrider = class_1890.method_8232((class_1309)entity);
        if (depthStrider > 3.0f) {
            depthStrider = 3.0f;
        }
        if (!entity.method_24828()) {
            depthStrider *= 0.5f;
        }
        if (depthStrider > 0.0f) {
            movementSpeed += (0.54600006f - movementSpeed) * depthStrider / 3.0f;
            yVelocity += (entity.method_6029() - yVelocity) * depthStrider / 3.0f;
        }
        if (entity.method_6059(class_1294.field_5900)) {
            movementSpeed = 0.96f;
        }
        entity.method_5724(yVelocity, movementInput);
        entity.method_5784(class_1313.field_6308, entity.method_18798());
        class_243 velocity = entity.method_18798();
        if (entity.field_5976 && entity.method_6101()) {
            velocity = new class_243(velocity.field_1352, 0.2, velocity.field_1350);
        }
        entity.method_18799(velocity.method_18805((double)movementSpeed, (double)0.8f, (double)movementSpeed));
        class_243 fluidSpeed = entity.method_26317(gravity, falling, entity.method_18798());
        entity.method_18799(fluidSpeed);
        if (entity.field_5976 && entity.method_5654(fluidSpeed.field_1352, fluidSpeed.field_1351 + (double)0.6f - entity.method_23318() + y, fluidSpeed.field_1350)) {
            entity.method_18800(fluidSpeed.field_1352, (double)0.3f, fluidSpeed.field_1350);
        }
    }

    public void swim(class_1309 entity) {
        entity.method_18799(entity.method_18798().method_1031(0.0, (double)0.04f, 0.0));
    }

    public boolean canWalkOn(class_1309 entity, class_243 movementInput, class_3610 state) {
        return entity.method_26319(state);
    }

    public abstract class_2394 getBubbleParticle(class_1297 var1);

    public abstract class_2394 getSplashParticle(class_1297 var1);

    public class_3414 getSplashSound(class_1297 entity) {
        return ((EntityAccessor)entity).callGetSplashSound();
    }

    public class_3414 getHighSpeedSplashSound(class_1297 entity) {
        return ((EntityAccessor)entity).callGetHighSpeedSplashSound();
    }

    public boolean canBreathe(class_1309 entity) {
        return true;
    }
}

